/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OverloadFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kOverloadMsg = "OverloadFlexEvent";
    private static final ObjectId kOverloadOid = UtilityLineStatus.Overload.getObjectId();
    private static final ObjectId kOverloadSolvedOid = UtilityLineStatus.OverloadSolved.getObjectId();
    private static final Logger logger = LogManager.getLogger(OverloadFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getOverload();
        if (AggregatorState.find_matches(blArray, true) > this.theState.getTotalRedundantUps() && this.theState.getLastReportedOverloadState() != 2) {
            logger.info("OverloadFiringLogicRule.calculate(): firing Overload event ");
            if (this.theState.getLastReportedOverloadState() == 1) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kOverloadSolvedOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            }
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kOverloadOid, true, new EventMessageFormatter(kOverloadMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, UtilityLineStatus.Overload.getEventId()));
            this.theState.setLastReportedOverloadState(2);
        }
    }
}

