/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OverloadSolvedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kOverloadOid = UtilityLineStatus.Overload.getObjectId();
    private static final String kOverloadSolvedMsg = "OverloadSolvedFlexEvent";
    private static final ObjectId kOverloadSolvedOid = UtilityLineStatus.OverloadSolved.getObjectId();
    private static final Logger logger = LogManager.getLogger(OverloadSolvedFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getOverload();
        if (AggregatorState.find_matches(blArray, true) <= this.theState.getTotalRedundantUps() && this.theState.getLastReportedOverloadState() == 2) {
            logger.info("OverloadSolvedFiringLogicRule.calculate(): firing OverloadSolved event ");
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kOverloadOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kOverloadSolvedOid, true, new EventMessageFormatter(kOverloadSolvedMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, UtilityLineStatus.OverloadSolved.getEventId()));
            this.theState.setLastReportedOverloadState(1);
        }
    }
}

