/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.PSAggregatorUtils;
import com.apcc.m11.components.psaggregator.SinglePowerFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.pcns.ServiceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerFailedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kOnBatteryMsg = "PowerFailedFlexEvent";
    private static final String kSinglePowerFailedFlexEvent = "SinglePowerFailedFlexEvent";
    private static final ObjectId kPowerFailedOid = UtilityLineStatus.PowerFailed.getObjectId();
    private static final ObjectId kPowerRestoredOid = UtilityLineStatus.PowerRestored.getObjectId();
    private static final Logger logger = LogManager.getLogger(PowerFailedFiringLogicRule.class);

    public PowerFailedFiringLogicRule(ServiceManager serviceManager) {
        this.setServices(serviceManager);
    }

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getOnBattery();
        if (AggregatorState.find_matches(blArray, true) > this.theState.getTotalRedundantUps() && (this.theState.getLastReportedBatteryState() == 1 || this.theState.getLastReportedBatteryState() == 0)) {
            logger.info("PowerFailedFiringLogicRule.calculate(): firing PowerFailed event ");
            if (this.theState.getLastReportedBatteryState() == 1) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kPowerRestoredOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            }
            if (this.services.getAdvancedSetupHelper().isSingleUPSGroup(this.theState.getAggregatorIdx())) {
                String string = PSAggregatorUtils.getAddress(0, this.theManager);
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kPowerFailedOid, true, new SinglePowerFormatter(kSinglePowerFailedFlexEvent, string), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, UtilityLineStatus.PowerFailed.getEventId()));
            } else {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kPowerFailedOid, true, new EventMessageFormatter(kOnBatteryMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), false, UtilityLineStatus.PowerFailed.getEventId()));
            }
            this.theState.setLastReportedBatteryState(2);
        }
    }
}

