/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.PSAggregatorUtils;
import com.apcc.m11.components.psaggregator.SinglePowerFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.pcns.ServiceManager;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerFailedInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(PowerFailedInputEventRule.class);
    private static final String kSinglePowerFailedMsg = "SinglePowerFailedFlexEvent";
    private static final String kSinglePowerRestoredMsg = "SinglePowerRestoredIPFlexEvent";
    private static final ObjectId kSinglePowerFailedOid = MultipleEvent.SinglePowerFailed.getObjectId();
    private static final ObjectId kSinglePowerRestoredOid = MultipleEvent.SinglePowerRestored.getObjectId();

    public PowerFailedInputEventRule(ServiceManager serviceManager) {
        this.setServices(serviceManager);
    }

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(UtilityLineStatus.PowerFailed.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        logger.debug("PowerFailed: got an update from PS " + n + ", event is active: " + event.isActive());
        if (event.isActive()) {
            if (!this.theState.getOnBattery()[n]) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kSinglePowerRestoredOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                if (!this.services.getAdvancedSetupHelper().isSingleUPSGroup(this.theState.getAggregatorIdx())) {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(kSinglePowerFailedOid, true, (IFormatter)new SinglePowerFormatter(kSinglePowerFailedMsg, PSAggregatorUtils.getAddress(n, this.theManager)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                }
                this.theState.setOnBattery(n, true);
                try {
                    this.theManager.dataBusSet(Output.SinglePowerFailedState.getObjectId(), true);
                }
                catch (InvalidValueException invalidValueException) {
                    logger.error("error setting singlePowerFailedState");
                }
                catch (InvalidObjectIdException invalidObjectIdException) {
                    logger.error("error setting singlePowerFailedState");
                }
                catch (CommunicationException communicationException) {
                    logger.debug("error setting singlePowerFailedState");
                }
            }
        } else if (this.theState.getOnBattery()[n]) {
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kSinglePowerFailedOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            if (!this.services.getAdvancedSetupHelper().isSingleUPSGroup(this.theState.getAggregatorIdx())) {
                logger.info("Send SinglePowerRestored event ");
                this.theManager.dispatchEvent(new AdvancedGroupEvent(kSinglePowerRestoredOid, true, new SinglePowerFormatter(kSinglePowerRestoredMsg, PSAggregatorUtils.getAddress(n, this.theManager)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, MultipleEvent.SinglePowerRestored.getEventId()));
            }
            this.theState.setOnBattery(n, false);
            try {
                this.theManager.dataBusSet(Output.SinglePowerFailedState.getObjectId(), false);
            }
            catch (InvalidValueException invalidValueException) {
                logger.error("error setting singlePowerFailedState");
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.error("error setting singlePowerFailedState");
            }
            catch (CommunicationException communicationException) {
                logger.debug("error setting singlePowerFailedState");
            }
        }
    }
}

