/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.SinglePowerFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.util.HostNameLookUpTable;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerRestoredInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final String kPowerOnEventMsg = "PowerOnIPFlexEvent";
    private static final Logger logger = LogManager.getLogger(PowerRestoredInputEventRule.class);

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(UtilityLineStatus.PowerRestored.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        if (event.isActive()) {
            logger.info("PowerRestored: got an update from PS " + n);
            this.theState.setOnBattery(n, false);
            this.theState.setLowBattery(n, false);
            boolean[] blArray = this.theState.getPowerOff();
            if (blArray[n]) {
                this.theState.setPowerOff(n, false);
                InetAddress inetAddress = null;
                try {
                    inetAddress = (InetAddress)this.theManager.dataBusGet(n, TCPIPCommunication.IpAddress.getObjectId());
                }
                catch (InvalidObjectIdException invalidObjectIdException) {
                    // empty catch block
                }
                this.theManager.dispatchEvent(new AdvancedGroupEvent(UtilityLineStatus.PowerRestored.getObjectId(), true, new SinglePowerFormatter(kPowerOnEventMsg, HostNameLookUpTable.getInstance().lookUp(inetAddress)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true, UtilityLineStatus.PowerRestored.getEventId()));
            }
        }
    }
}

