/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReturnFromLowBatteryFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kReturnFromLowBatteryMsg = "ReturnFromLowBatteryFlexEvent";
    private static final ObjectId kLowBatteryOid = Battery.LowBattery.getObjectId();
    private static final ObjectId kReturnFromLowBatteryOid = Battery.ReturnFromLowBattery.getObjectId();
    private static final Logger logger = LogManager.getLogger(ReturnFromLowBatteryFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getLowBattery();
        if (AggregatorState.find_matches(blArray, true) <= this.theState.getTotalRedundantUps() && this.theState.getLastReportedLowBatteryState() == 1) {
            logger.debug("ReturnFromLowBatteryFiringLogicRule.calculate(): firing LowBattery event ");
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kLowBatteryOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kReturnFromLowBatteryOid, true, new EventMessageFormatter(kReturnFromLowBatteryMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName(), true));
            this.theState.setLastReportedLowBatteryState(2);
        }
    }
}

