/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TurnOffInitiatedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kPowerSourceTurnOffInitiatedMsg = "PowerSourceTurnOffInitiatedFlexEvent";
    private static final String kPowerSourceTurnOffMsg = "PowerSourceTurnOffFlexEvent";
    private static final ObjectId kTurnOffInitiatedOid = ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId();
    private static final Logger logger = LogManager.getLogger(TurnOffInitiatedFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getUpsTurnOffInitiated();
        boolean[] blArray2 = this.theState.getPowerOff();
        int n = AggregatorState.find_matches(blArray, true);
        if (n > this.theState.getTotalRedundantUps()) {
            if (this.theState.getLastReportedUpsTurnOffState() == 0) {
                logger.info("firing TurnOffInitiated event for:" + this.theState.getAdvancedGroupName());
                if (AggregatorState.find_matches(blArray, true) == 1) {
                    logger.debug("Turn Off event fired by input event rule");
                } else {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(kTurnOffInitiatedOid, true, (IFormatter)new EventMessageFormatter(kPowerSourceTurnOffInitiatedMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                }
                this.theState.setLastReportedUpsTurnOffState(1);
            }
        } else if (n == 0 && this.theState.getLastReportedUpsTurnOffState() == 1) {
            logger.info("Clear TurnOffInitiated state for:" + this.theState.getAdvancedGroupName());
            this.theManager.dispatchEvent(new AdvancedGroupEvent(kTurnOffInitiatedOid, false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            this.theState.setLastReportedUpsTurnOffState(0);
        }
        if (AggregatorState.find_matches(blArray2, true) > this.theState.getTotalRedundantUps()) {
            if (this.theState.getLastReportedPowerOffState() == 0) {
                logger.info("firing TurnOff event ");
                if (AggregatorState.find_matches(blArray2, true) == 1) {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(UtilityLineStatus.PowerOff.getObjectId(), true, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                } else {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(UtilityLineStatus.PowerOff.getObjectId(), true, (IFormatter)new EventMessageFormatter(kPowerSourceTurnOffMsg), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                }
                this.theState.setLastReportedPowerOffState(2);
            }
        } else if (this.theState.getLastReportedPowerOffState() == 2) {
            logger.info("Clear PowerOffInitiated state");
            this.theManager.dispatchEvent(new AdvancedGroupEvent(UtilityLineStatus.PowerOff.getObjectId(), false, this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            this.theState.setLastReportedPowerOffState(0);
        }
    }
}

