/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.advanced;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.PSAggregatorUtils;
import com.apcc.m11.components.psaggregator.SinglePowerFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TurnOffInitiatedInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(TurnOffInitiatedInputEventRule.class);
    private static final String kSingleUPSTurnOffInitiatedMsg = "SingleUPSTurnOffInitiatedFlexEvent";
    private static final String kSingleUPSTurnOffClearedMsg = "SingleUPSTurnOffClearedFlexEvent";

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        logger.info("TurnOffInitiated: got an update from PS " + n + ", event is active: " + event.isActive());
        if (event.isActive()) {
            if (!this.theState.getUpsTurnOffInitiated()[n]) {
                if (this.theState.getTotalRedundantUps() >= 1) {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(MultipleEvent.SingleUPSEvent.getObjectId(), true, (IFormatter)new SinglePowerFormatter(kSingleUPSTurnOffInitiatedMsg, PSAggregatorUtils.getAddress(n, this.theManager)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                } else {
                    this.theManager.dispatchEvent(new AdvancedGroupEvent(ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId(), true, (IFormatter)new SinglePowerFormatter(kSingleUPSTurnOffInitiatedMsg, PSAggregatorUtils.getAddress(n, this.theManager)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
                }
            }
            this.theState.setUpsTurnOffInitiated(n, true);
        } else {
            if (this.theState.getUpsTurnOffInitiated()[n]) {
                this.theManager.dispatchEvent(new AdvancedGroupEvent(MultipleEvent.SingleUPSEvent.getObjectId(), true, (IFormatter)new SinglePowerFormatter(kSingleUPSTurnOffClearedMsg, PSAggregatorUtils.getAddress(n, this.theManager)), this.theState.getAggregatorIdx(), this.theState.getAdvancedGroupName()));
            }
            this.theState.setUpsTurnOffInitiated(n, false);
            this.theState.checkOffInitiatedbyPCNS();
        }
    }
}

