/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.advanced;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.rules.data.common.SetResultAgg;
import com.apcc.m11.ds.powersource.Battery;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.m11.ds.powersource.Configuration;
import com.apcc.m11.ds.powersource.DependentDevices;
import com.apcc.m11.ds.powersource.Identification;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroupsAsOneListDataRule
implements IDataRule {
    private static final Logger logger = LogManager.getLogger(GroupsAsOneListDataRule.class);
    private ServiceManager services;
    DataAggregatorRuleManager theManager;

    public GroupsAsOneListDataRule(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Identification.ModelNameList.getObjectId());
        vector.add(TCPIPCommunication.IpAddress.getObjectId());
        vector.add(TCPIPCommunication.OutletGroupList.getObjectId());
        vector.add(TCPIPCommunication.OutletGroup.getObjectId());
        vector.add(DependentDevices.ListOfDevices.getObjectId());
        vector.add(Communication.CommunicationConnectLog.getObjectId());
        vector.add(Identification.FirmwareRevision.getObjectId());
        vector.add(Identification.EventSelector.getObjectId());
        vector.add(Identification.ManufactureDate.getObjectId());
        vector.add(Identification.UPS_SKU.getObjectId());
        vector.add(Identification.NMC_SKU.getObjectId());
        vector.add(Identification.NMC_FW.getObjectId());
        vector.add(Battery.LastBatteryReplacementDate.getObjectId());
        vector.add(Configuration.LowBatteryRuntimeList.getObjectId());
        vector.add(Battery.RuntimeRemainingList.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = null;
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        getResult = new GetResult();
        Vector<Object> vector2 = new Vector<Object>();
        for (IDataSource iDataSource : vector) {
            try {
                GetResult getResult2 = iDataSource.get(objectId);
                Object object = getResult2.getValue();
                if (object instanceof Vector) {
                    Vector vector3 = (Vector)object;
                    vector2.addAll(vector3);
                    continue;
                }
                vector2.add(object);
            }
            catch (Exception exception) {
                vector2.add("NA");
            }
        }
        getResult.setValue(vector2);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        return this.get(objectId);
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        return this.get(objectId);
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        SetResultAgg setResultAgg = new SetResultAgg();
        if (objectId.equals((Object)TCPIPCommunication.IpAddress.getObjectId())) {
            if (object instanceof InetAddress) {
                Vector<IDataSource> vector = this.theManager.getAllDataSources();
                for (IDataSource iDataSource : vector) {
                    SetResult setResult = iDataSource.set(objectId, object);
                    setResultAgg.addSetResult(setResult);
                }
            } else {
                Object object2;
                if (!(object instanceof Vector)) {
                    throw new InvalidValueException("Expecting a vector here.");
                }
                Vector vector = (Vector)object;
                this.services.getAdvancedSetupHelper().clearNMCAddress();
                ConfigurationManager configurationManager = this.services.getConfigurationManager();
                for (int i = 0; i < vector.size(); ++i) {
                    object2 = (InetAddress)vector.get(i);
                    configurationManager.setProperty("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(i), ((InetAddress)object2).getHostAddress());
                }
                Vector<IDataSource> vector2 = this.theManager.getAllDataSources();
                object2 = this.services.getAdvancedSetupHelper().getNMCListsForUPSSetups();
                for (int i = 0; i < object2.size(); ++i) {
                    String string2;
                    List list = (List)object2.get(i);
                    Vector<InetAddress> vector3 = new Vector<InetAddress>();
                    for (String string2 : list) {
                        try {
                            vector3.add(InetAddress.getByName(string2));
                        }
                        catch (UnknownHostException unknownHostException) {
                            logger.error((Object)unknownHostException);
                        }
                    }
                    IDataSource iDataSource = vector2.get(i);
                    string2 = iDataSource.set(objectId, vector3);
                    setResultAgg.addSetResult((SetResult)string2);
                }
            }
        } else if (objectId.equals((Object)Communication.CommunicationConnectLog.getObjectId()) || objectId.equals((Object)TCPIPCommunication.OutletGroup.getObjectId())) {
            Vector<IDataSource> vector = this.theManager.getAllDataSources();
            for (IDataSource iDataSource : vector) {
                SetResult setResult = iDataSource.set(objectId, object);
                setResultAgg.addSetResult(setResult);
            }
        } else {
            throw new InvalidObjectIdException();
        }
        return setResultAgg;
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

