/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.advanced;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.rules.data.common.SetResultAgg;
import com.apcc.m11.ds.powersource.Battery;
import com.apcc.m11.ds.powersource.Configuration;
import com.apcc.m11.ds.powersource.DependentDevices;
import com.apcc.m11.ds.powersource.OperatingStatus;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroupsAsVectorDataRule
implements IDataRule {
    private static final Logger logger = LogManager.getLogger(GroupsAsVectorDataRule.class);
    DataAggregatorRuleManager theManager;

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Battery.RuntimeRemaining.getObjectId());
        vector.add(Configuration.LowBatteryRuntime.getObjectId());
        vector.add(OperatingStatus.PowerSourceShutdownDelay.getObjectId());
        vector.add(Battery.RuntimeRemainingforThreshold.getObjectId());
        vector.add(DependentDevices.GroupListOfDevices.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = null;
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        getResult = new GetResult();
        Vector<Object> vector2 = new Vector<Object>();
        for (IDataSource iDataSource : vector) {
            try {
                GetResult getResult2 = iDataSource.get(objectId);
                Object object = getResult2.getValue();
                vector2.add(object);
            }
            catch (Exception exception) {}
        }
        getResult.setValue(vector2);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        return this.get(objectId);
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        return this.get(objectId);
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        SetResultAgg setResultAgg = new SetResultAgg();
        if (!(object instanceof Vector)) {
            throw new InvalidValueException();
        }
        Vector vector = (Vector)object;
        Vector<IDataSource> vector2 = this.theManager.getAllDataSources();
        if (vector.size() != vector2.size()) {
            throw new InvalidValueException();
        }
        for (int i = 0; i < vector2.size(); ++i) {
            SetResult setResult = vector2.get(i).set(objectId, vector.get(i));
            setResultAgg.addSetResult(setResult);
        }
        return setResultAgg;
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

