/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.common;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.ds.powersource.Communication;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommunicationStatus
implements IDataRule {
    private static final Logger logger = LogManager.getLogger(CommunicationStatus.class);
    DataAggregatorRuleManager theManager;

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Communication.CommunicationStatus.getObjectId());
        return vector.iterator();
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        Integer n = 1;
        if (vector.isEmpty()) {
            n = 2;
        }
        for (IDataSource iDataSource : vector) {
            try {
                GetResult getResult2 = iDataSource.get(objectId);
                Object object = getResult2.getValue();
                if (object instanceof Integer) {
                    if ((Integer)object != 2) continue;
                    n = 2;
                    continue;
                }
                logger.debug("Communication Status is not an integer.  Unexpected");
                n = 2;
            }
            catch (Exception exception) {
                logger.error("Exception getting Communication Status", (Throwable)exception);
                n = 2;
            }
        }
        getResult.setValue((Object)n);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        return this.get(objectId);
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        return this.get(objectId);
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }
}

