/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.common;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.rules.data.common.SetResultAgg;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommunicationStatusLogFinishedDataRule
implements IDataRule {
    private static final Logger logger = LogManager.getLogger(CommunicationStatusLogFinishedDataRule.class);
    DataAggregatorRuleManager theManager;

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Communication.CommunicationConnectLogStatus.getObjectId());
        return vector.iterator();
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (IDataSource iDataSource : vector) {
            try {
                GetResult getResult2 = iDataSource.get(objectId);
                Object object = getResult2.getValue();
                String string = "";
                try {
                    GetResult getResult3 = iDataSource.get(TCPIPCommunication.IpAddress.getObjectId());
                    string = ((InetAddress)getResult3.getValue()).getHostAddress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object instanceof Integer) {
                    hashMap.put(string, (Integer)object);
                    continue;
                }
                logger.debug("shouldnt happen");
            }
            catch (Exception exception) {
                logger.error("shouldnt happen", (Throwable)exception);
            }
        }
        hashMap.put("combo", this.combineStatus(hashMap));
        getResult.setValue(hashMap);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        return this.get(objectId);
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        return this.get(objectId);
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        SetResultAgg setResultAgg = new SetResultAgg();
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        for (IDataSource iDataSource : vector) {
            try {
                setResultAgg.addSetResult(iDataSource.set(objectId, object));
            }
            catch (Exception exception) {}
        }
        return setResultAgg;
    }

    private Integer combineStatus(Map<String, Integer> map) {
        Integer n = map.containsValue(0) ? Integer.valueOf(0) : (map.containsValue(10) ? Integer.valueOf(10) : (map.containsValue(2) ? Integer.valueOf(2) : (map.containsValue(4) ? Integer.valueOf(4) : (map.containsValue(3) ? Integer.valueOf(3) : (map.containsValue(5) ? Integer.valueOf(5) : (map.containsValue(6) ? Integer.valueOf(6) : (map.containsValue(7) ? Integer.valueOf(7) : (map.containsValue(8) ? Integer.valueOf(8) : Integer.valueOf(1)))))))));
        return n;
    }
}

