/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.common;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.PowerSourceManager;
import com.apcc.m11.ds.powersource.Identification;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelTypeListDataRule
implements IDataRule {
    private static final Logger logger = LogManager.getLogger(ModelTypeListDataRule.class);
    private AggregatorState theState;
    DataAggregatorRuleManager theManager;

    public ModelTypeListDataRule(AggregatorState aggregatorState) {
        this.theState = aggregatorState;
    }

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Identification.ModelNameList.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = null;
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        getResult = new GetResult();
        Vector<Object> vector2 = new Vector<Object>();
        for (IDataSource iDataSource : vector) {
            Object object = null;
            try {
                GetResult getResult2 = iDataSource.get(objectId);
                object = getResult2.getValue();
                vector2.add(object);
            }
            catch (CommunicationException communicationException) {
                object = "null";
                vector2.add(object);
            }
            catch (Exception exception) {}
        }
        getResult.setValue(vector2);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null) {
            return iDataSource.get(objectId, n);
        }
        throw new CommunicationException("no datasource");
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null) {
            return iDataSource.get(objectId, object);
        }
        throw new CommunicationException("no datasource");
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        logger.debug(">set" + String.valueOf(objectId));
        SetResult setResult = new SetResult();
        if (Identification.ModelNameList.getObjectId().equals((Object)objectId)) {
            boolean bl = true;
            if (!(object instanceof Vector)) {
                throw new InvalidValueException("Expecting a vector here.");
            }
            logger.debug("set Models List");
            Vector vector = (Vector)object;
            PowerSourceManager powerSourceManager = PowerSourceManager.getCurrentInstance(this.theState.getAggregatorIdx());
            if (powerSourceManager != null) {
                powerSourceManager.setNumberOfComponents(vector.size());
                powerSourceManager.startComponents();
            }
            Vector<IDataSource> vector2 = this.theManager.getAllDataSources();
            Vector<SetResult> vector3 = new Vector<SetResult>();
            for (int i = 0; i < vector.size(); ++i) {
                GetResult getResult;
                String string;
                IDataSource iDataSource = vector2.get(i);
                String string2 = (String)vector.get(i);
                if (string2.equals(string = (String)(getResult = iDataSource.get(Identification.ModelNameList.getObjectId())).getValue())) continue;
                logger.debug("change model");
                vector3.add(iDataSource.set(Identification.ModelNameList.getObjectId(), (Object)string2));
            }
            for (SetResult setResult2 : vector3) {
                bl &= setResult2.wasSuccessful();
            }
            setResult.setSuccessful(bl);
        }
        logger.debug("<set" + String.valueOf(objectId));
        return setResult;
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

