/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.common;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.rules.data.common.SetResultAgg;
import com.apcc.m11.components.webserver.cfgwizard.Setting;
import com.apcc.m11.ds.esxiconfiguration.ESXIConfig;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import java.util.Iterator;
import java.util.Vector;

public class SameOnAllDataRule
implements IDataRule {
    DataAggregatorRuleManager theManager;

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(TCPIPCommunication.MulticastAddress.getObjectId());
        vector.add(TCPIPCommunication.UnicastAddress.getObjectId());
        vector.add(TCPIPCommunication.AuthUserName.getObjectId());
        vector.add(TCPIPCommunication.PasswordPhrase.getObjectId());
        vector.add(TCPIPCommunication.AuthKey.getObjectId());
        vector.add(TCPIPCommunication.PollInterval.getObjectId());
        vector.add(TCPIPCommunication.LocalhostAddress.getObjectId());
        vector.add(TCPIPCommunication.EventReceiverPort.getObjectId());
        vector.add(ESXIConfig.ChangeMode.getObjectId());
        vector.add(TCPIPCommunication.PasswordPhrase.getObjectId());
        vector.add(Setting.TurnOffPowerSourceOnShutdown.getObjectId());
        vector.add(Setting.TurnOffSOGOnShutdown.getObjectId());
        vector.add(Output.SinglePowerFailedState.getObjectId());
        vector.add(OperatingStatus.PowerSourceTurnOffTime.getObjectId());
        vector.add(OperatingStatus.PowerSourceTurnOffOnBattery.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null) {
            return iDataSource.get(objectId);
        }
        throw new CommunicationException("no datasource");
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null) {
            return iDataSource.get(objectId, n);
        }
        throw new CommunicationException("no datasource");
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null) {
            return iDataSource.get(objectId, object);
        }
        throw new CommunicationException("no datasource");
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        SetResultAgg setResultAgg = new SetResultAgg();
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        for (IDataSource iDataSource : vector) {
            setResultAgg.addSetResult(iDataSource.set(objectId, object));
        }
        return setResultAgg;
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

