/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.common;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.PowerSourceManager;
import com.apcc.m11.components.psaggregator.rules.data.common.SetResultAgg;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TcpIpDataRule
implements IDataRule {
    private static final Logger logger = LogManager.getLogger(TcpIpDataRule.class);
    private AggregatorState theState;
    private ServiceManager services;
    DataAggregatorRuleManager theManager;

    public TcpIpDataRule(AggregatorState aggregatorState, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.theState = aggregatorState;
    }

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(TCPIPCommunication.DataRequestPort.getObjectId());
        vector.add(TCPIPCommunication.Protocol.getObjectId());
        vector.add(TCPIPCommunication.IpAddress.getObjectId());
        vector.add(TCPIPCommunication.OutletGroupList.getObjectId());
        vector.add(TCPIPCommunication.OutletGroup.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = null;
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        if (objectId.equals((Object)TCPIPCommunication.IpAddress.getObjectId()) || objectId.equals((Object)TCPIPCommunication.DataRequestPort.getObjectId()) || objectId.equals((Object)TCPIPCommunication.OutletGroupList.getObjectId())) {
            getResult = new GetResult();
            Vector<Object> vector2 = new Vector<Object>();
            for (IDataSource iDataSource : vector) {
                try {
                    GetResult getResult2 = iDataSource.get(objectId);
                    Object object = getResult2.getValue();
                    vector2.add(object);
                }
                catch (Exception exception) {}
            }
            getResult.setValue(vector2);
        } else {
            getResult = vector.get(0).get(objectId);
        }
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null) {
            return iDataSource.get(objectId, n);
        }
        throw new CommunicationException("no datasource");
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null) {
            return iDataSource.get(objectId, object);
        }
        throw new CommunicationException("no datasource");
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        logger.debug(">set" + String.valueOf(objectId));
        SetResultAgg setResultAgg = new SetResultAgg();
        if (TCPIPCommunication.IpAddress.getObjectId().equals((Object)objectId)) {
            if (object instanceof InetAddress) {
                this.services.getConfigurationManager().setProperty("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(0), ((InetAddress)object).getHostAddress());
            } else {
                if (!(object instanceof Vector)) {
                    throw new InvalidValueException("Expecting a vector here.");
                }
                logger.debug("set IP List");
                Vector vector = (Vector)object;
                PowerSourceManager powerSourceManager = PowerSourceManager.getCurrentInstance(this.theState.getAggregatorIdx());
                if (powerSourceManager != null) {
                    powerSourceManager.setNumberOfComponents(vector.size());
                    powerSourceManager.startComponents();
                }
                Vector<IDataSource> vector2 = this.theManager.getAllDataSources();
                for (int i = 0; i < vector.size(); ++i) {
                    GetResult getResult;
                    InetAddress inetAddress;
                    IDataSource iDataSource = vector2.get(i);
                    InetAddress inetAddress2 = (InetAddress)vector.get(i);
                    if (inetAddress2.equals(inetAddress = (InetAddress)(getResult = iDataSource.get(TCPIPCommunication.IpAddress.getObjectId())).getValue())) continue;
                    logger.debug("change address");
                    setResultAgg.addSetResult(iDataSource.set(TCPIPCommunication.IpAddress.getObjectId(), (Object)inetAddress2));
                }
            }
        } else if (TCPIPCommunication.DataRequestPort.getObjectId().equals((Object)objectId) || TCPIPCommunication.Protocol.getObjectId().equals((Object)objectId) || TCPIPCommunication.OutletGroup.getObjectId().equals((Object)objectId)) {
            Vector<IDataSource> vector = this.theManager.getAllDataSources();
            for (IDataSource iDataSource : vector) {
                try {
                    setResultAgg.addSetResult(iDataSource.set(objectId, object));
                }
                catch (Exception exception) {}
            }
        } else {
            throw new InvalidObjectIdException();
        }
        logger.debug("<set" + String.valueOf(objectId));
        return setResultAgg;
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

