/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.common;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.ds.powersource.Battery;
import com.apcc.m11.ds.powersource.Configuration;
import com.apcc.m11.ds.powersource.Identification;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VectorOfAllDataRule
implements IDataRule {
    private static final Logger logger = LogManager.getLogger(VectorOfAllDataRule.class);
    DataAggregatorRuleManager theManager;

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Identification.FirmwareRevision.getObjectId());
        vector.add(Identification.EventSelector.getObjectId());
        vector.add(Identification.ManufactureDate.getObjectId());
        vector.add(Identification.UPS_SKU.getObjectId());
        vector.add(Identification.NMC_SKU.getObjectId());
        vector.add(Identification.NMC_FW.getObjectId());
        vector.add(Battery.LastBatteryReplacementDate.getObjectId());
        vector.add(Configuration.LowBatteryRuntimeList.getObjectId());
        vector.add(Battery.RuntimeRemainingList.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = null;
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        getResult = new GetResult();
        Vector<Object> vector2 = new Vector<Object>();
        for (IDataSource iDataSource : vector) {
            try {
                GetResult getResult2 = iDataSource.get(objectId);
                Object object = getResult2.getValue();
                vector2.add(object);
            }
            catch (Exception exception) {
                logger.debug("Exception getting {}: {}", (Object)objectId, (Object)exception);
                vector2.add("NA");
            }
        }
        getResult.setValue(vector2);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null) {
            return iDataSource.get(objectId, n);
        }
        throw new CommunicationException("no datasource");
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null) {
            return iDataSource.get(objectId, object);
        }
        throw new CommunicationException("no datasource");
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

