/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.parallel;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.StringFormatter;
import com.apcc.m11.ds.powersource.Identification;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelTypeDataRule
implements IDataRule {
    private static final Logger logger = LogManager.getLogger(ModelTypeDataRule.class);
    private static final String kParallelModelName = "Parallel UPS";
    private static final String kParallelSilcon = "Parallel Silcon UPS";
    private static final String kParallelVT = "Parallel Smart-UPS VT";
    private static final String kParallelSRC = "Parallel Smart-UPS SRC";
    private static final String kParallelMStar = "Parallel MGE Galaxy 300";
    private static final String kParallelMStar3500 = "Parallel MGE Galaxy 3500";
    private static final String kParallelGalaxy = "Parallel Galaxy";
    private static final String kParallelGalaxyVM = "Parallel Galaxy VM";
    private static final String kParallelGalaxy7000 = "Parallel Galaxy 7000";
    private static final String kParallelMStar5000 = "Parallel MGE Galaxy 5000";
    private static final String kParallelMStar5500 = "Parallel MGE Galaxy 5500";
    private static final String kParallelMStar6000 = "Parallel MGE Galaxy 6000";
    private static final String kParallelMStar9000 = "Parallel MGE Galaxy 9000";
    private static final String kParallelMStarEPS6000 = "Parallel MGE EPS 6000";
    private static final String kParallelMStarEPS7000 = "Parallel MGE EPS 7000";
    private static final String kParallelMStarEPS8000E = "Parallel MGE EPS 8000E";
    private static final String kParallelMStarEPS8000 = "Parallel MGE EPS 8000";
    private static final String kParallelSymmetra = "Parallel Symmetra";
    private static final String kSmartUPSModelType = "SMART-UPS";
    private static final String kSmartUPSVTType = "VT";
    private static final String kSilconType = "SILCON";
    private static final String kGalaxyModelType = "GALAXY";
    private static final String kGalaxyVMModelType = "GALAXY VM";
    private static final String kGalaxy7000ModelType = "GALAXY 7\\d\\d\\d.*";
    private static final String kMStarGalaxyUPS5000ModelType = ".*MGE GALAXY 5[0]\\d\\d.*";
    private static final String kMStarGalaxyUPS5500ModelType = ".*MGE GALAXY 5[5]\\d\\d.*";
    private static final String kMStarGalaxyUPS6000ModelType = ".*MGE GALAXY 6\\d\\d\\d.*";
    private static final String kMStarGalaxyUPS9000ModelType = ".*MGE GALAXY 9\\d\\d\\d.*";
    private static final String KMStarEPS6000ModelType = ".*MGE EPS 6\\d\\d\\d.*";
    private static final String KMStarEPS7000ModelType = ".*MGE EPS 7\\d\\d\\d.*";
    private static final String KMStarEPS8000EModelType = ".*MGE EPS 8\\d\\d\\d[E].*";
    private static final String KMStarEPS8000ModelType = ".*MGE EPS 8\\d\\d\\d.*";
    private static final String kSRCModelType = "SRC";
    private static final String kMStarType = "MGE GALAXY 3[0]\\d.*";
    private static final String kMStarType3500 = "MGE GALAXY 3[5]\\d.*";
    private static final String kSymmetraType = "SYMMETRA";
    DataAggregatorRuleManager theManager;

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Identification.ModelName.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        String string;
        GetResult getResult = new GetResult();
        getResult.setValue((Object)kParallelModelName);
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null && (string = (String)(getResult = iDataSource.get(objectId)).getValue()) != null) {
            if (string.toUpperCase().indexOf(kSilconType) >= 0) {
                getResult.setValue((Object)kParallelSilcon);
            } else if (Pattern.matches(kMStarType, string.toUpperCase())) {
                getResult.setValue((Object)kParallelMStar);
            } else if (Pattern.matches(kMStarType3500, string.toUpperCase())) {
                getResult.setValue((Object)kParallelMStar3500);
            } else if (Pattern.matches(kGalaxy7000ModelType, string.toUpperCase())) {
                getResult.setValue((Object)kParallelGalaxy7000);
            } else if (Pattern.matches(kMStarGalaxyUPS5000ModelType, string.toUpperCase())) {
                getResult.setValue((Object)kParallelMStar5000);
            } else if (Pattern.matches(kMStarGalaxyUPS5500ModelType, string.toUpperCase())) {
                getResult.setValue((Object)kParallelMStar5500);
            } else if (Pattern.matches(kMStarGalaxyUPS6000ModelType, string.toUpperCase())) {
                getResult.setValue((Object)kParallelMStar6000);
            } else if (Pattern.matches(kMStarGalaxyUPS9000ModelType, string.toUpperCase())) {
                getResult.setValue((Object)kParallelMStar9000);
            } else if (Pattern.matches(KMStarEPS6000ModelType, string.toUpperCase())) {
                getResult.setValue((Object)kParallelMStarEPS6000);
            } else if (Pattern.matches(KMStarEPS7000ModelType, string.toUpperCase())) {
                getResult.setValue((Object)kParallelMStarEPS7000);
            } else if (Pattern.matches(KMStarEPS8000EModelType, string.toUpperCase())) {
                getResult.setValue((Object)kParallelMStarEPS8000E);
            } else if (Pattern.matches(KMStarEPS8000ModelType, string.toUpperCase())) {
                getResult.setValue((Object)kParallelMStarEPS8000);
            } else if (string.toUpperCase().indexOf(kSmartUPSModelType) >= 0 && string.toUpperCase().indexOf(kSmartUPSVTType) >= 0) {
                getResult.setValue((Object)kParallelVT);
            } else if (string.toUpperCase().indexOf(kGalaxyVMModelType) >= 0) {
                getResult.setValue((Object)kParallelGalaxyVM);
            } else if (string.toUpperCase().indexOf(kGalaxyModelType) >= 0) {
                getResult.setValue((Object)kParallelGalaxy);
            } else if (string.toUpperCase().indexOf(kSymmetraType) >= 0) {
                getResult.setValue((Object)kParallelSymmetra);
            } else if (string.toUpperCase().indexOf(kSRCModelType) >= 0) {
                getResult.setValue((Object)kParallelSRC);
            } else {
                getResult.setValue((Object)kParallelModelName);
            }
            logger.info(string);
        }
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        Object object = null;
        switch (n) {
            case 0: {
                return this.get(objectId);
            }
            case 2: {
                object = null;
                break;
            }
            case 1: {
                object = Availability.AVAILABLE;
                break;
            }
            case 3: {
                object = new StringFormatter();
                break;
            }
            default: {
                getResult.setError();
            }
        }
        getResult.setValue(object);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

