/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.parallel;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.StringFormatter;
import com.apcc.m11.ds.powersource.OperatingStatus;
import java.util.Iterator;
import java.util.Vector;

public class PowerSourceShutdownDelayDataRule
implements IDataRule {
    DataAggregatorRuleManager theManager;

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(OperatingStatus.PowerSourceShutdownDelay.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        int n = 1440;
        for (IDataSource iDataSource : vector) {
            try {
                GetResult getResult2 = iDataSource.get(objectId);
                Integer n2 = (Integer)getResult2.getValue();
                if (n2 >= n) continue;
                n = n2;
            }
            catch (Exception exception) {}
        }
        getResult.setValue((Object)n);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        StringFormatter stringFormatter = null;
        switch (n) {
            case 0: {
                return this.get(objectId);
            }
            case 2: {
                stringFormatter = null;
                break;
            }
            case 1: {
                stringFormatter = new Availability(true);
                break;
            }
            case 3: {
                stringFormatter = new StringFormatter();
                break;
            }
            default: {
                getResult.setError();
            }
        }
        getResult.setValue((Object)stringFormatter);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        for (IDataSource iDataSource : vector) {
            iDataSource.set(objectId, object);
        }
        SetResult setResult = new SetResult();
        setResult.setSuccessful(true);
        return setResult;
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

