/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.parallel;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.StringFormatter;
import com.apcc.m11.ds.powersource.Battery;
import com.apcc.m11.ds.powersource.Configuration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeVerifierDataRule
implements IDataRule {
    private static final Logger logger = LogManager.getLogger(RuntimeVerifierDataRule.class);
    private AggregatorState theState;
    DataAggregatorRuleManager theManager;

    public RuntimeVerifierDataRule(AggregatorState aggregatorState) {
        this.theState = aggregatorState;
    }

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Battery.RuntimeRemaining.getObjectId());
        vector.add(Configuration.LowBatteryRuntime.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        IDataSource iDataSource2;
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        int n = Integer.MAX_VALUE;
        int n2 = this.theState.getUnitsRequiredForLoad();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (IDataSource iDataSource2 : vector) {
            try {
                GetResult getResult = iDataSource2.get(objectId);
                vector2.add((Integer)getResult.getValue());
            }
            catch (CommunicationException communicationException) {
                logger.debug("Unable to get OID:" + String.valueOf(objectId));
            }
        }
        Collections.sort(vector2);
        int n3 = vector2.size() - n2;
        if (n3 < 0) {
            throw new CommunicationException();
        }
        n = (Integer)vector2.get(vector2.size() - n2);
        iDataSource2 = new GetResult();
        iDataSource2.setValue((Object)n);
        return iDataSource2;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        Object object = null;
        switch (n) {
            case 0: {
                return this.get(objectId);
            }
            case 2: {
                object = null;
                break;
            }
            case 1: {
                object = Availability.AVAILABLE;
                break;
            }
            case 3: {
                object = new StringFormatter();
                break;
            }
            default: {
                getResult.setError();
            }
        }
        getResult.setValue(object);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

