/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.redundant;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.StringFormatter;
import com.apcc.m11.ds.powersource.Identification;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;

public class ModelTypeDataRule
implements IDataRule {
    private static final String kMultiSmartUpsRTModelName = "Redundant Smart-UPS RT";
    private static final String kMultiMStarModelName = "Redundant MGE Galaxy 300";
    private static final String kMultiSmartUpsModelName = "Redundant Smart-UPS";
    private static final String kMultiSymmetraModelName = "Redundant Symmetra";
    private static final String kMultiGalaxyModelName = "Redundant Galaxy";
    private static final String kMultiGalaxy7000ModelName = "Redundant Galaxy 7000";
    private static final String kMultiSmartUpsSRTModelName = "Redundant Smart-UPS SRT";
    private static final String kMultiSmartUpsSRCModelName = "Redundant Smart-UPS SRC";
    private static final String kGalaxyModelType = "GALAXY";
    private static final String kSymmetraModelType = ".*SYMMETRA.*";
    private static final String kSmartUpsRTMicrolinkModelType = "SMART-UPS RT";
    private static final String kSmartUpsRCModelType = "SMART-UPS RC";
    private static final String kIBMMicroLinkModelType = "IBM UPS\u0001";
    private static final String kGalaxy7000ModelType = "GALAXY 7\\d\\d\\d.*";
    private static final String kMStarType = "MGE GALAXY 3\\d\\d.*";
    private static final String kSmartUpsSRTModelType = ".*SMART-UPS SRT.*";
    private static final String kSmartUpsSRCModelType = ".*SMART-UPS SRC.*";
    private DataAggregatorRuleManager theManager;

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Identification.ModelName.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = null;
        String string = null;
        String string2 = "";
        IDataSource iDataSource = this.theManager.getFirstDataSource();
        if (iDataSource != null && !(getResult = iDataSource.get(objectId)).hasError() && getResult.getValue() instanceof String) {
            string2 = (String)getResult.getValue();
            string2 = string2.toUpperCase();
        }
        string = Pattern.matches(kMStarType, string2.toUpperCase()) ? kMultiMStarModelName : (Pattern.matches(kGalaxy7000ModelType, string2.toUpperCase()) ? kMultiGalaxy7000ModelName : (string2.toUpperCase().indexOf(kGalaxyModelType) >= 0 ? kMultiGalaxyModelName : (string2.toUpperCase().indexOf(kSmartUpsRTMicrolinkModelType) >= 0 || string2.toUpperCase().indexOf(kSmartUpsRCModelType) >= 0 || string2.toUpperCase().indexOf(kIBMMicroLinkModelType) >= 0 ? kMultiSmartUpsRTModelName : (Pattern.matches(kSymmetraModelType, string2.toUpperCase()) ? kMultiSymmetraModelName : (Pattern.matches(kSmartUpsSRTModelType, string2.toUpperCase()) ? kMultiSmartUpsSRTModelName : (Pattern.matches(kSmartUpsSRCModelType, string2.toUpperCase()) ? kMultiSmartUpsSRCModelName : kMultiSmartUpsModelName))))));
        getResult = new GetResult();
        getResult.setValue((Object)string);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        Object object = null;
        switch (n) {
            case 0: {
                return this.get(objectId);
            }
            case 2: {
                object = null;
                break;
            }
            case 1: {
                object = Availability.AVAILABLE;
                break;
            }
            case 3: {
                object = new StringFormatter();
                break;
            }
            default: {
                getResult.setError();
            }
        }
        getResult.setValue(object);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

