/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.data.redundant;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.components.psaggregator.DataAggregatorRuleManager;
import com.apcc.m11.components.psaggregator.IDataRule;
import com.apcc.m11.components.psaggregator.StringFormatter;
import com.apcc.m11.ds.powersource.Battery;
import com.apcc.m11.ds.powersource.Configuration;
import java.util.Iterator;
import java.util.Vector;

public class RuntimeVerifierDataRule
implements IDataRule {
    DataAggregatorRuleManager theManager;

    @Override
    public Iterator<ObjectId> getOids() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Battery.RuntimeRemaining.getObjectId());
        vector.add(Configuration.LowBatteryRuntime.getObjectId());
        return vector.iterator();
    }

    @Override
    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        Vector<IDataSource> vector = this.theManager.getAllDataSources();
        int n = Integer.MAX_VALUE;
        for (IDataSource iDataSource : vector) {
            GetResult getResult = iDataSource.get(objectId);
            Integer n2 = (Integer)getResult.getValue();
            if (n2 >= n) continue;
            n = n2;
        }
        GetResult getResult = new GetResult();
        getResult.setValue((Object)n);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        Object object = null;
        switch (n) {
            case 0: {
                return this.get(objectId);
            }
            case 2: {
                object = null;
                break;
            }
            case 1: {
                object = Availability.AVAILABLE;
                break;
            }
            case 3: {
                object = new StringFormatter();
                break;
            }
            default: {
                getResult.setError();
            }
        }
        getResult.setValue(object);
        return getResult;
    }

    @Override
    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }

    @Override
    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException();
    }

    @Override
    public void setDataAggregatorRuleManager(DataAggregatorRuleManager dataAggregatorRuleManager) {
        this.theManager = dataAggregatorRuleManager;
    }
}

