/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatteryChargeInRangeFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kBatteryChargeInRangeMsg = "BatteryChargeInRangeFlexEvent";
    private static final ObjectId kBatteryChargeInRangeOid = Battery.BatteryChargeInRange.getObjectId();
    private static final ObjectId kBatteryDischargedOid = Battery.BatteryDischarged.getObjectId();
    private static final Logger logger = LogManager.getLogger(BatteryChargeInRangeFiringLogicRule.class);

    @Override
    public void calculate() {
        int n = this.theState.getUnitsRequiredForLoad();
        boolean[] blArray = this.theState.getAvailableToPowerLoad();
        boolean[] blArray2 = this.theState.getDischarged();
        boolean[] blArray3 = this.theState.getStatusOK();
        boolean[] blArray4 = AggregatorState.and(blArray2, blArray3);
        int n2 = AggregatorState.find_matches(AggregatorState.and(AggregatorState.not(blArray4), blArray), true);
        logger.info("calculate(): " + n2 + "," + n);
        int n3 = AggregatorState.find_matches(AggregatorState.and(blArray4, blArray), true);
        logger.info("calculate(): " + n3 + "," + n);
        int n4 = AggregatorState.find_matches(blArray3, true) - n;
        if (n4 < 0) {
            n4 = 0;
        }
        if (!(n4 < n3 && !AggregatorState.all(blArray4, false) || this.theState.getLastReportedDischargeState() != 2 || this.theState.getLastReportedBatteryState() != 1 && this.theState.getLastReportedBatteryState() != 0)) {
            logger.info("BatteryChargeInRangeFiringLogicRule.calculate(): firing BatteryChargeInRange event ");
            this.theManager.dispatchEvent(new Event(kBatteryDischargedOid, false));
            this.theManager.dispatchEvent(new DetailedEvent(kBatteryChargeInRangeOid, true, new EventMessageFormatter(kBatteryChargeInRangeMsg), true, Battery.BatteryChargeInRange.getEventId()));
            this.theState.setLastReportedDischargeState(1);
        }
    }
}

