/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatteryDischargedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kBatteryChargeInRangeOid = Battery.BatteryChargeInRange.getObjectId();
    private static final String kBatteryDischargedMsg = "BatteryDischargedFlexEvent";
    private static final ObjectId kBatteryDischargedOid = Battery.BatteryDischarged.getObjectId();
    private static final Logger logger = LogManager.getLogger(BatteryDischargedFiringLogicRule.class);

    @Override
    public void calculate() {
        int n = this.theState.getUnitsRequiredForLoad();
        boolean[] blArray = this.theState.getAvailableToPowerLoad();
        boolean[] blArray2 = this.theState.getDischarged();
        boolean[] blArray3 = this.theState.getStatusOK();
        boolean[] blArray4 = AggregatorState.and(blArray2, blArray3);
        logger.info("calculate(): " + AggregatorState.toString(blArray4));
        int n2 = AggregatorState.find_matches(AggregatorState.and(blArray4, blArray), true);
        int n3 = AggregatorState.find_matches(blArray3, true) - n;
        if (n3 < 0) {
            n3 = 0;
        }
        logger.info("calculate(): ok:" + AggregatorState.toString(blArray3));
        logger.info("calculate(): discharged_and_comm:" + AggregatorState.toString(blArray4));
        logger.info("calculate(): " + n2 + "," + n + "," + n3);
        if (!(n2 <= n3 || !AggregatorState.any(blArray4, true) || this.theState.getLastReportedDischargeState() != 0 && this.theState.getLastReportedDischargeState() != 1 || this.theState.getLastReportedBatteryState() != 1 && this.theState.getLastReportedBatteryState() != 0)) {
            logger.info("BatteryDischargedFiringLogicRule.calculate(): firing BatteryDischarged event ");
            if (this.theState.getLastReportedDischargeState() == 1) {
                this.theManager.dispatchEvent(new Event(kBatteryChargeInRangeOid, false));
            }
            this.theManager.dispatchEvent(new DetailedEvent(kBatteryDischargedOid, true, new EventMessageFormatter(kBatteryDischargedMsg), false, Battery.BatteryDischarged.getEventId()));
            this.theState.setLastReportedDischargeState(2);
        }
    }
}

