/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Bypass;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BypassDisabledFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kBypassDisabledMsg = "BypassDisabledFlexEvent";
    private static final ObjectId kBypassDisabledOid = Bypass.BypassDisabled.getObjectId();
    private static final ObjectId kBypassEnabledOid = Bypass.BypassEnabled.getObjectId();
    private static final Logger logger = LogManager.getLogger(BypassDisabledFiringLogicRule.class);

    @Override
    public void calculate() {
        int n = this.theState.getUnitsRequiredForLoad();
        boolean[] blArray = this.theState.getOnBypass();
        boolean[] blArray2 = this.theState.getHotStandby();
        boolean[] blArray3 = this.theState.getStatusOK();
        boolean[] blArray4 = AggregatorState.and(blArray, blArray3);
        boolean[] blArray5 = AggregatorState.and(blArray4, AggregatorState.not(blArray2));
        int n2 = AggregatorState.find_matches(blArray3, true) - n;
        if (n2 < 0) {
            n2 = 0;
        }
        if (AggregatorState.find_matches(blArray5, true) <= n2 && this.theState.getLastReportedBypassState() == 1) {
            logger.info("BypassDisabledFiringLogicRule.calculate(): firing BypassDisabled event ");
            this.theManager.dispatchEvent(new Event(kBypassEnabledOid, false));
            this.theManager.dispatchEvent(new DetailedEvent(kBypassDisabledOid, true, new EventMessageFormatter(kBypassDisabledMsg), true, Bypass.BypassDisabled.getEventId()));
            this.theState.setLastReportedBypassState(2);
        }
    }
}

