/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Bypass;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BypassEnabledFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kBypassDisabledMsg = "BypassDisabledFlexEvent";
    private static final ObjectId kBypassDisabledOid = Bypass.BypassDisabled.getObjectId();
    private static final String kMaintBypassEnabledMsg = "MaintenanceBypassEnabledFlexEvent";
    private static final ObjectId kBypassEnabledOid = Bypass.BypassEnabled.getObjectId();
    private static final String kFaultBypassEnabledMsg = "FaultBypassEnabledFlexEvent";
    private static final ObjectId kFaultBypassEnabledOid = Bypass.FaultBypassEnabled.getObjectId();
    private static final Logger logger = LogManager.getLogger(BypassEnabledFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean bl = this.theState.isEventActive(kBypassEnabledOid) || this.theState.isEventActive(kFaultBypassEnabledOid);
        logger.info("BypassFiringLogicRule: wasInBypass:" + bl + " Enabled:" + this.theState.isEventActive(kBypassEnabledOid) + " Fault:" + this.theState.isEventActive(kFaultBypassEnabledOid));
        this.doEventReason(1, kFaultBypassEnabledOid, kFaultBypassEnabledMsg, Bypass.FaultBypassEnabled.getEventId());
        this.doEventReason(0, kBypassEnabledOid, kMaintBypassEnabledMsg, Bypass.BypassEnabled.getEventId());
        boolean bl2 = this.theState.isEventActive(kBypassEnabledOid) || this.theState.isEventActive(kFaultBypassEnabledOid);
        logger.info("BypassFiringLogicRule: isInBypass:" + bl2 + " Enabled:" + this.theState.isEventActive(kBypassEnabledOid) + " Fault:" + this.theState.isEventActive(kFaultBypassEnabledOid));
        if (bl && !bl2) {
            logger.info("BypassFiringLogicRule: firing BypassDisabledEvent");
            this.theManager.dispatchEvent(new DetailedEvent(kBypassDisabledOid, true, new EventMessageFormatter(kBypassDisabledMsg), true, Bypass.BypassDisabled.getEventId()));
        }
        if (this.theState.isEventActive(kBypassDisabledOid) && bl2) {
            this.theManager.dispatchEvent(new Event(kBypassDisabledOid, false, (IFormatter)new EventMessageFormatter(kBypassDisabledMsg)));
        }
    }

    private void doEventReason(int n, ObjectId objectId, String string, String string2) {
        int n2;
        int n3 = this.theState.getUnitsRequiredForLoad();
        int[] nArray = this.theState.getOnBypassReason();
        boolean[] blArray = this.theState.getOnBypass();
        boolean[] blArray2 = this.theState.getHotStandby();
        boolean[] blArray3 = this.theState.getStatusOK();
        boolean[] blArray4 = AggregatorState.and(AggregatorState.and(blArray, AggregatorState.not(blArray2)), blArray3);
        int n4 = 0;
        for (n2 = 0; n2 < blArray4.length; ++n2) {
            if (!blArray4[n2] || nArray[n2] != n) continue;
            ++n4;
        }
        n2 = AggregatorState.find_matches(blArray3, true) - n3;
        if (n2 < 0) {
            n2 = 0;
        }
        logger.info("doEventReason: spare_units:" + n2);
        logger.info("doEventReason: required_units:" + n3);
        logger.info("doEventReason: bypass_enabled:" + AggregatorState.toString(blArray));
        logger.info("doEventReason: status_ok:" + AggregatorState.toString(blArray3));
        logger.info("doEventReason: bypass_enabled_and_not_hot_standby:" + AggregatorState.toString(blArray4));
        if (n4 > n2) {
            if (!this.theState.isEventActive(objectId)) {
                this.theManager.dispatchEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), false, string2));
            }
        } else if (this.theState.isEventActive(objectId)) {
            this.theManager.dispatchEvent(new Event(objectId, false, (IFormatter)new EventMessageFormatter(string)));
        }
    }
}

