/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Bypass;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BypassManualDisabledFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kBypassManualDisabledMsg = "BypassManualDisabledFlexEvent";
    private static final ObjectId kBypassDisabledOid = Bypass.BypassDisabled.getObjectId();
    private static final ObjectId kBypassManualEnabledOid = Bypass.BypassManualEnabled.getObjectId();
    private static final Logger logger = LogManager.getLogger(BypassManualDisabledFiringLogicRule.class);

    @Override
    public void calculate() {
        int n = this.theState.getUnitsRequiredForLoad();
        boolean[] blArray = this.theState.getOnManualBypass();
        boolean[] blArray2 = this.theState.getHotStandby();
        boolean[] blArray3 = this.theState.getStatusOK();
        boolean[] blArray4 = AggregatorState.and(AggregatorState.and(blArray, AggregatorState.not(blArray2)), blArray3);
        int n2 = AggregatorState.find_matches(blArray4, true);
        int n3 = AggregatorState.find_matches(blArray3, true) - n;
        if (n3 < 0) {
            n3 = 0;
        }
        logger.debug("calculate: spare_units:" + n3);
        logger.debug("calculate: required_units:" + n);
        logger.debug("calculate: bypass_enabled:" + AggregatorState.toString(blArray));
        logger.debug("calculate: status_ok:" + AggregatorState.toString(blArray3));
        logger.debug("calculate: bypass_enabled_and_not_hot_standby:" + AggregatorState.toString(blArray4));
        if (n2 <= n3 && this.theState.getLastReportedManualBypassState() == 1) {
            logger.info("BypassManualDisabledFiringLogicRule.calculate(): firing BypassDisabled event ");
            this.theManager.dispatchEvent(new Event(kBypassManualEnabledOid, false));
            this.theManager.dispatchEvent(new DetailedEvent(kBypassDisabledOid, true, new EventMessageFormatter(kBypassManualDisabledMsg), true));
            this.theState.setLastReportedManualBypassState(2);
        }
    }
}

