/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommLostFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kCommEstablishedOid = Communication.CommunicationEstablished.getObjectId();
    private static final String kCommLostMsg = "CommunicationLostFlexEvent";
    private static final ObjectId kCommLostOid = Communication.CommunicationLost.getObjectId();
    private static final ObjectId kNetCommLostOid = Communication.NetCommunicationLost.getObjectId();
    private static final Logger logger = LogManager.getLogger(CommLostFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray;
        int n = this.theState.getCommEstablished().length;
        boolean[] blArray2 = AggregatorState.not(this.theState.getCommEstablished());
        if (AggregatorState.find_matches(AggregatorState.and(blArray2, blArray = AggregatorState.not(this.theState.getOnBattery())), true) >= n && AggregatorState.all(this.theState.getNetCommEstablished(), true) && AggregatorState.all(this.theState.getPowerSourceReported(), true) && this.theState.getLastReportedCommState() != 2 && this.theState.getLastReportedCommState() != 4) {
            logger.info("CommLostFiringLogicRule.calculate(): firing CommLost event ");
            if (this.theState.getLastReportedCommState() == 1) {
                this.theManager.dispatchEvent(new Event(kCommEstablishedOid, false));
            } else if (this.theState.getLastReportedCommState() == 3) {
                this.theManager.dispatchEvent(new Event(kNetCommLostOid, false));
            }
            this.theManager.dispatchEvent(new DetailedEvent(kCommLostOid, true, new EventMessageFormatter(kCommLostMsg), false, Communication.CommunicationLost.getEventId()));
            this.theState.setLastReportedCommState(2);
        }
    }
}

