/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.CannotCommunicateFormatter;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.util.HostNameLookUpTable;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommLostInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(CommLostInputEventRule.class);

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        logger.debug("CommLostInputEventRule");
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(Communication.CommunicationLost.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        logger.debug("CommLostInputEventRule: from PS " + n);
        if (event.isActive()) {
            logger.info("CommLostInputEventRule: got an update from PS " + n);
            this.theState.setPowerSourceReported(n, true);
            this.theState.setCommEstablished(n, false);
            this.theState.setNetCommEstablished(n, true);
            try {
                InetAddress inetAddress = (InetAddress)this.theManager.dataBusGet(n, TCPIPCommunication.IpAddress.getObjectId());
                this.theManager.dispatchEvent(new Event(Communication.CannotCommunicate.getObjectId(), true, (IFormatter)new CannotCommunicateFormatter("CannotCommunicateWithUPSFlexEvent", HostNameLookUpTable.getInstance().lookUp(inetAddress))));
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.info((Object)invalidObjectIdException);
            }
        }
    }
}

