/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommLostWhileOnBatteryFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kCommEstablishedOid = Communication.CommunicationEstablished.getObjectId();
    private static final ObjectId kCommLostOid = Communication.CommunicationLost.getObjectId();
    private static final String kCommLostWhileOnBatteryMsg = "CommunicationLostWhileOnBattFlexEvent";
    private static final ObjectId kCommLostWhileOnBatteryOid = Communication.CommunicationLostOnBattery.getObjectId();
    private static final ObjectId kNetCommLostOid = Communication.NetCommunicationLost.getObjectId();
    private static final Logger logger = LogManager.getLogger(CommLostWhileOnBatteryFiringLogicRule.class);

    @Override
    public void calculate() {
        if (this.isEventOccur()) {
            logger.info("CommLostWhileOnBatteryFiringLogicRule.calculate(): firing CommLost event ");
            if (this.theState.getLastReportedCommState() == 1) {
                this.theManager.dispatchEvent(new Event(kCommEstablishedOid, false));
            } else if (this.theState.getLastReportedCommState() == 2) {
                this.theManager.dispatchEvent(new Event(kCommLostOid, false));
            } else if (this.theState.getLastReportedCommState() == 3) {
                this.theManager.dispatchEvent(new Event(kNetCommLostOid, false));
            }
            this.theManager.dispatchEvent(new DetailedEvent(kCommLostWhileOnBatteryOid, true, new EventMessageFormatter(kCommLostWhileOnBatteryMsg), false, Communication.CommunicationLostOnBattery.getEventId()));
            this.theState.setLastReportedCommState(4);
        }
    }

    private boolean isEventOccur() {
        boolean[] blArray;
        boolean bl = false;
        logger.info("CommLostWhileOnBatteryFiringLogicRule.isEventOccure()");
        logger.info("CommLostWhileOnBatteryFiringLogicRule.isEventOccure() LastReport:" + this.theState.getLastReportedBatteryState());
        if ((this.theState.getLastReportedBatteryState() == 2 || this.theState.getLastReportedBatteryState() == 3) && AggregatorState.all(blArray = AggregatorState.and(this.theState.getNetCommEstablished(), this.theState.getCommEstablished()), false) && this.theState.getLastReportedCommState() != 4) {
            bl = true;
        }
        return bl;
    }
}

