/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Temperature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InternalTempFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kInternalTempExceededMsg = "InternalTempExceeded";
    private static final ObjectId kInternalTempExceededOid = Temperature.MaxInternalTempExceeded.getObjectId();
    private static final String kInternalTempInRangeMsg = "InternalTempInRange";
    private static final ObjectId kInternalTempInRangeOid = Temperature.MaxInternalTempInRange.getObjectId();
    private static final Logger logger = LogManager.getLogger(InternalTempFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getStatusOK();
        boolean[] blArray2 = AggregatorState.not(this.theState.getInternalTempOK());
        boolean[] blArray3 = AggregatorState.and(blArray2, blArray);
        int n = this.theState.getUnitsRequiredForLoad();
        int n2 = AggregatorState.find_matches(blArray, true) - n;
        if (n2 < 0) {
            n2 = 0;
        }
        logger.info("InternalTempFiringLogicRule.calculate(): Calculating ");
        if (AggregatorState.find_matches(blArray3, true) > n2 && this.theState.getLastReportedInternalTempState() != 2) {
            logger.info("InternalTempFiringLogicRule.calculate(): firing temp Exceeded event ");
            if (this.theState.getLastReportedOverloadState() == 1) {
                this.theManager.dispatchEvent(new Event(kInternalTempInRangeOid, false));
            }
            this.theManager.dispatchEvent(new DetailedEvent(kInternalTempExceededOid, true, new EventMessageFormatter(kInternalTempExceededMsg), false, Temperature.MaxInternalTempExceeded.getEventId()));
            this.theState.setLastReportedInternalTempState(2);
        } else if (AggregatorState.find_matches(blArray3, true) <= n2 && this.theState.getLastReportedInternalTempState() == 2) {
            logger.info("InternalTempFiringLogicRule.calculate(): firing temp OK event ");
            this.theManager.dispatchEvent(new Event(kInternalTempExceededOid, false));
            this.theManager.dispatchEvent(new DetailedEvent(kInternalTempInRangeOid, true, new EventMessageFormatter(kInternalTempInRangeMsg), true, Temperature.MaxInternalTempInRange.getEventId()));
            this.theState.setLastReportedInternalTempState(1);
        }
    }
}

