/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LowBatteryFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kLowBatteryMsg = "LowBatteryFlexEvent";
    private static final ObjectId kLowBatteryOid = Battery.LowBattery.getObjectId();
    private static final ObjectId kReturnFromLowBatteryOid = Battery.ReturnFromLowBattery.getObjectId();
    private static final Logger logger = LogManager.getLogger(LowBatteryFiringLogicRule.class);

    @Override
    public void calculate() {
        int n = this.theState.getUnitsRequiredForLoad();
        boolean[] blArray = this.theState.getLowBattery();
        boolean[] blArray2 = this.theState.getStatusOK();
        boolean[] blArray3 = AggregatorState.and(blArray, blArray2);
        int n2 = AggregatorState.find_matches(blArray3, true);
        int n3 = AggregatorState.find_matches(blArray2, true) - n;
        if (n3 < 0) {
            n3 = 0;
        }
        logger.debug("spare_units=" + n3);
        logger.debug("low_battery_units=" + n2);
        logger.debug("last reported low battery state =" + this.theState.getLastReportedLowBatteryState());
        if (n2 > n3 && AggregatorState.any(blArray3, true) && (this.theState.getLastReportedLowBatteryState() == 0 || this.theState.getLastReportedLowBatteryState() == 2)) {
            logger.info("LowBatteryFiringLogicRule.calculate(): firing LowBattery event ");
            if (this.theState.getLastReportedLowBatteryState() == 2) {
                this.theManager.dispatchEvent(new Event(kReturnFromLowBatteryOid, false));
            }
            this.theManager.dispatchEvent(new Event(kLowBatteryOid, true, (IFormatter)new EventMessageFormatter(kLowBatteryMsg)));
            this.theState.setLastReportedLowBatteryState(1);
        }
    }
}

