/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Redundancy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinRedundancyFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kMinRedundancyLostMsg = "MinRedundancyLostFlexEvent";
    private static final ObjectId kMinRedundancyLostOid = Redundancy.MinRedundancyLost.getObjectId();
    private static final String kMinRedundancyRegainedMsg = "MinRedundancyRegainedFlexEvent";
    private static final ObjectId kMinRedundancyRegainedOid = Redundancy.MinRedundancyRegained.getObjectId();
    private static final Logger logger = LogManager.getLogger(MinRedundancyFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getCommEstablished();
        boolean[] blArray2 = AggregatorState.and(this.theState.getNetCommEstablished(), this.theState.getPowerSourceReported());
        boolean[] blArray3 = this.theState.getPowerSourceOff();
        boolean[] blArray4 = AggregatorState.and(blArray, AggregatorState.and(blArray2, AggregatorState.not(blArray3)));
        int n = this.theState.getUnitsRequiredForLoad();
        int n2 = AggregatorState.find_matches(blArray4, true) - n;
        if (n2 < 0) {
            n2 = 0;
        }
        boolean[] blArray5 = AggregatorState.and(this.theState.getMinRedundancyLost(), blArray4);
        logger.debug("Number Lost Redundancy:" + AggregatorState.find_matches(blArray5, true));
        if (AggregatorState.find_matches(blArray5, true) > 0) {
            if (this.theState.getLastReportedMinRedundancyState() != 1) {
                logger.info("MinRedundancyFiringLogicRule.calculate(): firing MinimumRedundancyLost event ");
                if (this.theState.getLastReportedMinRedundancyState() == 2) {
                    this.theManager.dispatchEvent(new Event(kMinRedundancyRegainedOid, false));
                }
                this.theManager.dispatchEvent(new DetailedEvent(kMinRedundancyLostOid, true, new EventMessageFormatter(kMinRedundancyLostMsg), false, Redundancy.MinRedundancyLost.getEventId()));
                this.theState.setLastReportedMinRedundancyState(1);
            }
        } else if (this.theState.getLastReportedMinRedundancyState() != 2) {
            if (this.theState.getLastReportedMinRedundancyState() == 1) {
                logger.info("MinRedundancyFiringLogicRule.calculate(): firing MinimumRedundancyRegained event ");
                this.theManager.dispatchEvent(new Event(kMinRedundancyLostOid, false));
                this.theManager.dispatchEvent(new DetailedEvent(kMinRedundancyRegainedOid, true, new EventMessageFormatter(kMinRedundancyRegainedMsg), true, Redundancy.MinRedundancyRegained.getEventId()));
            }
            this.theState.setLastReportedMinRedundancyState(2);
        }
    }
}

