/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.RawFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitoringStartedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kMonitoringStartedOid = Communication.MonitoringStarted.getObjectId();
    private static final Logger logger = LogManager.getLogger(MonitoringStartedFiringLogicRule.class);

    @Override
    public void calculate() {
        if (AggregatorState.all(this.theState.getMonitoringStarted(), true) && !this.theState.getMonitoringStartedReportedState()) {
            logger.info("MonitoringStartedFiringLogicRule.calculate(): firing MonitoringStarted event ");
            String string = this.theState.getMonitoringStartedText();
            if (string != null) {
                this.theManager.dispatchEvent(new DetailedEvent(kMonitoringStartedOid, true, new RawFormatter(string), true, Communication.MonitoringStarted.getEventId()));
                this.theState.setMonitoringStartedReportedState(true);
            }
        }
    }
}

