/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletTurnOffInitiatedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kOutletTurnOffInitiatedMsg = "OutletTurnOffInitiatedFlexEvent";
    private static final ObjectId kOutletTurnOffInitiatedOid = ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId();
    private static final Logger logger = LogManager.getLogger(OutletTurnOffInitiatedFiringLogicRule.class);

    @Override
    public void calculate() {
        int n = this.theState.getUnitsRequiredForLoad();
        boolean[] blArray = this.theState.getAvailableToPowerLoad();
        boolean[] blArray2 = this.theState.getCommEstablished();
        boolean[] blArray3 = AggregatorState.and(this.theState.getNetCommEstablished(), this.theState.getPowerSourceReported());
        boolean[] blArray4 = this.theState.getOutletTurnOffInitiated();
        int n2 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i] || blArray4[i]) continue;
            ++n2;
        }
        boolean[] blArray5 = AggregatorState.and(AggregatorState.and(blArray4, blArray3), blArray2);
        if (n > n2 && AggregatorState.any(blArray5, true)) {
            if (this.theState.getLastReportedOutletTurnOffState() == 0) {
                logger.info("firing OutletTurnOffInitiated event ");
                this.theManager.dispatchEvent(new Event(kOutletTurnOffInitiatedOid, true, (IFormatter)new EventMessageFormatter(kOutletTurnOffInitiatedMsg)));
                this.theState.setLastReportedOutletTurnOffState(1);
            }
        } else if (this.theState.getLastReportedOutletTurnOffState() == 1) {
            this.theManager.dispatchEvent(new Event(kOutletTurnOffInitiatedOid, false));
            logger.info("Clear OutletTurnOffInitiated state");
            this.theState.setLastReportedOutletTurnOffState(0);
        }
    }
}

