/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OverloadSolvedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kOverloadOid = UtilityLineStatus.Overload.getObjectId();
    private static final String kOverloadSolvedMsg = "OverloadSolvedFlexEvent";
    private static final ObjectId kOverloadSolvedOid = UtilityLineStatus.OverloadSolved.getObjectId();
    private static final Logger logger = LogManager.getLogger(OverloadSolvedFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getStatusOK();
        boolean[] blArray2 = AggregatorState.and(this.theState.getOverload(), blArray);
        int n = this.theState.getUnitsRequiredForLoad();
        int n2 = AggregatorState.find_matches(blArray, true) - n;
        if (n2 < 0) {
            n2 = 0;
        }
        logger.info("calculate: required:" + n);
        logger.info("calculate: spares:" + n2);
        logger.info("calculate: status_ok" + AggregatorState.toString(blArray));
        logger.info("calculate: overload_and_comm" + AggregatorState.toString(blArray2));
        logger.info("calculate: overload" + AggregatorState.toString(this.theState.getOverload()));
        if (AggregatorState.find_matches(blArray2, true) <= n2 && this.theState.getLastReportedOverloadState() == 2) {
            logger.info("OverloadSolvedFiringLogicRule.calculate(): firing OverloadSolved event ");
            this.theManager.dispatchEvent(new Event(kOverloadOid, false));
            this.theManager.dispatchEvent(new DetailedEvent(kOverloadSolvedOid, true, new EventMessageFormatter(kOverloadSolvedMsg), true, UtilityLineStatus.OverloadSolved.getEventId()));
            this.theState.setLastReportedOverloadState(1);
        }
    }
}

