/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Redundancy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParallelRedundancyLostFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kParallelRedundancyLostMsg = "ParallelRedundancyLostFlexEvent";
    private static final ObjectId kParallelRedundancyLostOid = Redundancy.ParallelRedundancyLost.getObjectId();
    private static final String kParallelRedundancyRegainedMsg = "ParallelRedundancyRegainedFlexEvent";
    private static final ObjectId kParallelRedundancyRegainedOid = Redundancy.ParallelRedundancyRegained.getObjectId();
    private static final Logger logger = LogManager.getLogger(ParallelRedundancyLostFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getCommEstablished();
        boolean[] blArray2 = AggregatorState.and(this.theState.getNetCommEstablished(), this.theState.getPowerSourceReported());
        boolean[] blArray3 = this.theState.getPowerSourceOff();
        boolean[] blArray4 = AggregatorState.and(blArray, AggregatorState.and(blArray2, AggregatorState.not(blArray3)));
        int n = this.theState.getUnitsRequiredForLoad();
        int n2 = AggregatorState.find_matches(blArray4, true) - n;
        if (n2 < 0) {
            n2 = 0;
        }
        logger.info("ParallelRedundancyLostFiringLogicRule.calculate(): com_est:" + AggregatorState.toString(blArray));
        logger.info("ParallelRedundancyLostFiringLogicRule.calculate(): net_com_est:" + AggregatorState.toString(blArray2));
        logger.info("ParallelRedundancyLostFiringLogicRule.calculate(): turnedOff:" + AggregatorState.toString(blArray3));
        logger.info("ParallelRedundancyLostFiringLogicRule.calculate(): status_ok:" + AggregatorState.toString(blArray4));
        boolean[] blArray5 = AggregatorState.and(this.theState.getParallelRedundancyLost(), blArray4);
        logger.debug("Number Lost Redundancy:" + AggregatorState.find_matches(blArray5, true));
        if (AggregatorState.find_matches(blArray5, true) > n2) {
            if (this.theState.getLastReportedParallelRedundancyState() != 1) {
                logger.info("ParallelRedundancyLostFiringLogicRule.calculate(): firing ParallelRedundancyLost event ");
                if (this.theState.getLastReportedParallelRedundancyState() == 2) {
                    this.theManager.dispatchEvent(new Event(kParallelRedundancyRegainedOid, false));
                }
                this.theManager.dispatchEvent(new DetailedEvent(kParallelRedundancyLostOid, true, new EventMessageFormatter(kParallelRedundancyLostMsg), false, Redundancy.ParallelRedundancyLost.getEventId()));
                this.theState.setLastReportedParallelRedundancyState(1);
            }
        } else if (this.theState.getLastReportedParallelRedundancyState() != 2) {
            if (this.theState.getLastReportedParallelRedundancyState() == 1) {
                logger.info("ParallelRedundancyLostFiringLogicRule.calculate(): firing ParallelRedundancyRegained event ");
                this.theManager.dispatchEvent(new Event(kParallelRedundancyLostOid, false));
                this.theManager.dispatchEvent(new DetailedEvent(kParallelRedundancyRegainedOid, true, new EventMessageFormatter(kParallelRedundancyRegainedMsg), true, Redundancy.ParallelRedundancyRegained.getEventId()));
            }
            this.theState.setLastReportedParallelRedundancyState(2);
        }
    }
}

