/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.CannotCommunicateFormatter;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.events.internalevents.powersource.OperationalEvents;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.util.HostNameLookUpTable;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParallelSilconNotSupportedInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final ObjectId kInputOid = OperationalEvents.ParallelSilconNotSupported.getObjectId();
    private static final String kNotSupportedMsg = "ParallelSilconNotSupportedFlexEvent";
    private static final ObjectId kNotSupportedOid = Communication.ParallelSilconNotSupported.getObjectId();
    private static final Logger logger = LogManager.getLogger(ParallelSilconNotSupportedInputEventRule.class);

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(kInputOid);
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        if (event.isActive()) {
            logger.info("ParallelSilconNotSupportedInputEventRule: got an update from PS " + n);
            try {
                InetAddress inetAddress = (InetAddress)this.theManager.dataBusGet(n, TCPIPCommunication.IpAddress.getObjectId());
                this.theManager.dispatchEvent(new DetailedEvent(kNotSupportedOid, true, new CannotCommunicateFormatter(kNotSupportedMsg, HostNameLookUpTable.getInstance().lookUp(inetAddress)), false, Communication.ParallelSilconNotSupported.getEventId()));
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.info((Object)invalidObjectIdException);
            }
            this.theState.setPowerSourceOff(n, true);
        }
    }
}

