/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.CannotCommunicateFormatter;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.events.internalevents.powersource.OperationalEvents;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.util.HostNameLookUpTable;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParallelSilconSupportedInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final ObjectId kInputOid = OperationalEvents.ParallelSilconSupported.getObjectId();
    private static final String kSupportedMsg = "ParallelSilconSupportedFlexEvent";
    private static final ObjectId kSupportedOid = Communication.ParallelSilconSupported.getObjectId();
    private static final Logger logger = LogManager.getLogger(ParallelSilconSupportedInputEventRule.class);

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(kInputOid);
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        if (event.isActive()) {
            logger.info("ParallelSilconSupportedInputEventRule: got an update from PS " + n);
            try {
                InetAddress inetAddress = (InetAddress)this.theManager.dataBusGet(n, TCPIPCommunication.IpAddress.getObjectId());
                this.theManager.dispatchEvent(new Event(kSupportedOid, true, (IFormatter)new CannotCommunicateFormatter(kSupportedMsg, HostNameLookUpTable.getInstance().lookUp(inetAddress))));
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                logger.info((Object)invalidObjectIdException);
            }
            this.theState.setPowerSourceOff(n, false);
        }
    }
}

