/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerFailedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kOnBatteryMsg = "PowerFailedFlexEvent";
    private static final ObjectId kPowerFailedOid = UtilityLineStatus.PowerFailed.getObjectId();
    private static final ObjectId kPowerRestoredOid = UtilityLineStatus.PowerRestored.getObjectId();
    private static final Logger logger = LogManager.getLogger(PowerFailedFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getOnBattery();
        boolean[] blArray2 = this.theState.getHotStandby();
        boolean[] blArray3 = this.theState.getStatusOK();
        boolean[] blArray4 = AggregatorState.and(blArray, blArray3);
        boolean[] blArray5 = AggregatorState.and(blArray4, AggregatorState.not(blArray2));
        int n = this.theState.getUnitsRequiredForLoad();
        int n2 = AggregatorState.find_matches(blArray3, true) - n;
        if (n2 < 0) {
            n2 = 0;
        }
        logger.info("calculate(): spare_units:" + n2);
        logger.info("calculate(): required_units:" + n);
        logger.info("calculate(): status_ok:" + AggregatorState.toString(blArray3));
        logger.info("calculate(): onBattery:" + AggregatorState.toString(blArray));
        logger.info("calculate(): on_battery_and_comm_and_not_hot_standby:" + AggregatorState.toString(blArray5));
        if (AggregatorState.find_matches(blArray5, true) > n2 && (this.theState.getLastReportedBatteryState() == 1 || this.theState.getLastReportedBatteryState() == 0)) {
            logger.info("PowerFailedFiringLogicRule.calculate(): firing PowerFailed event ");
            if (this.theState.getLastReportedBatteryState() == 1) {
                this.theManager.dispatchEvent(new Event(kPowerRestoredOid, false));
            }
            this.theManager.dispatchEvent(new DetailedEvent(kPowerFailedOid, true, new EventMessageFormatter(kOnBatteryMsg), false, UtilityLineStatus.PowerFailed.getEventId()));
            this.theState.setLastReportedBatteryState(2);
        }
    }
}

