/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.parallel;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerRestoredFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kLostCommsOnBatteryOid = Communication.CommunicationLostOnBattery.getObjectId();
    private static final String kOnlineMsg = "PowerRestoredFlexEvent";
    private static final ObjectId kPowerFailedOid = UtilityLineStatus.PowerFailed.getObjectId();
    private static final ObjectId kPowerRestoredOid = UtilityLineStatus.PowerRestored.getObjectId();
    private static final Logger logger = LogManager.getLogger(PowerRestoredFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getOnBattery();
        boolean[] blArray2 = this.theState.getHotStandby();
        boolean[] blArray3 = this.theState.getCommEstablished();
        boolean[] blArray4 = AggregatorState.and(this.theState.getNetCommEstablished(), this.theState.getPowerSourceReported());
        boolean[] blArray5 = AggregatorState.and(blArray4, blArray3);
        boolean[] blArray6 = this.theState.getStatusOK();
        boolean[] blArray7 = AggregatorState.and(blArray, AggregatorState.not(blArray5));
        int n = this.theState.getUnitsRequiredForLoad();
        int n2 = AggregatorState.find_matches(blArray6, true) - n;
        if (n2 < 0) {
            n2 = 0;
        }
        if (AggregatorState.find_matches(blArray7, true) > n2) {
            if (this.theState.getLastReportedBatteryState() != 3) {
                this.theState.setLastReportedBatteryState(3);
            }
        } else if (this.theState.getLastReportedBatteryState() == 3) {
            this.theState.setLastReportedBatteryState(2);
        }
        if (this.theState.getLastReportedBatteryState() != 3) {
            boolean[] blArray8 = AggregatorState.and(AggregatorState.and(blArray, AggregatorState.not(blArray2)), blArray6);
            logger.info("calculate:On Battery:" + AggregatorState.toString(blArray) + ",Com ok:" + AggregatorState.toString(blArray5) + ",hot standby:" + AggregatorState.toString(blArray2) + ",on_battery_and_comm_and_not_hot_standby:" + AggregatorState.toString(blArray8) + "," + n + "," + n2);
            if (AggregatorState.find_matches(blArray8, true) <= n2 && this.theState.getLastReportedBatteryState() == 2) {
                logger.info("PowerRestoredFiringLogicRule.calculate(): firing PowerRestored event ");
                this.theManager.dispatchEvent(new Event(kPowerFailedOid, false));
                this.theManager.dispatchEvent(new DetailedEvent(kPowerRestoredOid, true, new EventMessageFormatter(kOnlineMsg), true, UtilityLineStatus.PowerRestored.getEventId()));
                this.theState.setLastReportedBatteryState(1);
            }
        }
    }
}

