/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatteryChargeInRangeFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kBatteryChargeInRangeMsg = "BatteryChargeInRangeFlexEvent";
    private static final ObjectId kBatteryChargeInRangeOid = Battery.BatteryChargeInRange.getObjectId();
    private static final ObjectId kBatteryDischargedOid = Battery.BatteryDischarged.getObjectId();
    private static final Logger logger = LogManager.getLogger(BatteryChargeInRangeFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getDischarged();
        if (AggregatorState.find_matches(blArray, true) <= 1 && this.theState.getLastReportedDischargeState() == 2) {
            logger.debug("BatteryChargeInRangeFiringLogicRule.calculate(): firing BatteryChargeInRange event ");
            this.theManager.dispatchEvent(new Event(kBatteryDischargedOid, false));
            this.theManager.dispatchEvent(new DetailedEvent(kBatteryChargeInRangeOid, true, new EventMessageFormatter(kBatteryChargeInRangeMsg), true, Battery.BatteryChargeInRange.getEventId()));
            this.theState.setLastReportedDischargeState(1);
        }
    }
}

