/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Bypass;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BypassManualFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kBypassManualDisabledMsg = "BypassManualDisabledFlexEvent";
    private static final ObjectId kBypassDisabledOid = Bypass.BypassDisabled.getObjectId();
    private static final String kManualBypassEnabledMsg = "ManualBypassEnabledFlexEvent";
    private static final ObjectId kBypassManualEnabledOid = Bypass.BypassManualEnabled.getObjectId();
    private static final Logger logger = LogManager.getLogger(BypassManualFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getOnManualBypass();
        if (AggregatorState.find_matches(blArray, true) > 1) {
            if (this.theState.getLastReportedManualBypassState() != 1) {
                logger.info("BypassManualFiringLogicRule.calculate(): firing BypassManualEnabled event ");
                if (this.theState.getLastReportedManualBypassState() == 2) {
                    this.theManager.dispatchEvent(new Event(kBypassDisabledOid, false));
                }
                this.theManager.dispatchEvent(new DetailedEvent(kBypassManualEnabledOid, true, new EventMessageFormatter(kManualBypassEnabledMsg), false, Bypass.BypassManualEnabled.getEventId()));
                this.theState.setLastReportedManualBypassState(1);
            }
        } else if (this.theState.getLastReportedManualBypassState() != 2) {
            if (this.theState.getLastReportedManualBypassState() == 1) {
                logger.info("BypassManualFiringLogicRule.calculate(): firing BypassDisabled event ");
                this.theManager.dispatchEvent(new Event(kBypassManualEnabledOid, false));
                this.theManager.dispatchEvent(new DetailedEvent(kBypassDisabledOid, true, new EventMessageFormatter(kBypassManualDisabledMsg), true));
            }
            this.theState.setLastReportedManualBypassState(2);
        }
    }
}

