/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommLostWhileOnBatteryFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final ObjectId kCommEstablishedOid = Communication.CommunicationEstablished.getObjectId();
    private static final ObjectId kCommLostOid = Communication.CommunicationLost.getObjectId();
    private static final String kCommLostWhileOnBatteryMsg = "CommunicationLostWhileOnBattFlexEvent";
    private static final ObjectId kCommLostWhileOnBatteryOid = Communication.CommunicationLostOnBattery.getObjectId();
    private static final ObjectId kNetCommLostOid = Communication.NetCommunicationLost.getObjectId();
    private static final Logger logger = LogManager.getLogger(CommLostWhileOnBatteryFiringLogicRule.class);

    @Override
    public void calculate() {
        if (this.isEventOccur()) {
            logger.info("CommLostWhileOnBatteryFiringLogicRule.calculate(): firing CommLost event ");
            if (this.theState.getLastReportedCommState() == 1) {
                this.theManager.dispatchEvent(new Event(kCommEstablishedOid, false));
            } else if (this.theState.getLastReportedCommState() == 2) {
                this.theManager.dispatchEvent(new Event(kCommLostOid, false));
            } else if (this.theState.getLastReportedCommState() == 3) {
                this.theManager.dispatchEvent(new Event(kNetCommLostOid, false));
            }
            this.theManager.dispatchEvent(new DetailedEvent(kCommLostWhileOnBatteryOid, true, new EventMessageFormatter(kCommLostWhileOnBatteryMsg), false, Communication.CommunicationLostOnBattery.getEventId()));
            this.theState.setLastReportedCommState(4);
        }
    }

    private boolean isEventOccur() {
        boolean bl = false;
        boolean[] blArray = AggregatorState.not(this.theState.getCommEstablished());
        boolean[] blArray2 = AggregatorState.not(this.theState.getNetCommEstablished());
        if (AggregatorState.find_matches(AggregatorState.and(blArray, this.theState.getOnBattery()), true) > 1 && AggregatorState.all(this.theState.getNetCommEstablished(), true) && AggregatorState.all(this.theState.getPowerSourceReported(), true) && this.theState.getLastReportedCommState() != 2 && this.theState.getLastReportedCommState() != 4) {
            bl = true;
        } else if (AggregatorState.find_matches(AggregatorState.and(blArray2, this.theState.getOnBattery()), true) > 1 && this.theState.getLastReportedCommState() != 3 && this.theState.getLastReportedCommState() != 4) {
            bl = true;
        } else if (AggregatorState.find_matches(AggregatorState.and(blArray2, this.theState.getOnBattery()), true) >= 1 && AggregatorState.find_matches(AggregatorState.and(blArray, this.theState.getOnBattery()), true) > 1 && this.theState.getLastReportedCommState() != 2 && this.theState.getLastReportedCommState() != 3 && this.theState.getLastReportedCommState() != 4) {
            bl = true;
        }
        return bl;
    }
}

