/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.PSAggregatorUtils;
import com.apcc.m11.components.psaggregator.VarArgFormatter;
import com.apcc.m11.ds.events.flexevents.EnvironmentalEvents;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnvironmentMonitorInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(EnvironmentMonitorInputEventRule.class);
    private Map<ObjectId, String> oidToFlexEventMapping = new Hashtable<ObjectId, String>();
    private List<ObjectId> supportedOids = new ArrayList<ObjectId>();
    private Set<ObjectId> infoEvents;

    public EnvironmentMonitorInputEventRule() {
        this.supportedOids.add(EnvironmentalEvents.ContactFault1.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.ContactFault2.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.ContactFault3.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.ContactFault4.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.ContactNormal1.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.ContactNormal2.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.ContactNormal3.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.ContactNormal4.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.EnvironmentCommunicationEstablished.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.EnvironmentCommunicationLost.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.EnvironmentNoCommunicationSinceLastReboot.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.HumidityInRangeProbe1.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.HumidityInRangeProbe2.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.HumidityOutOfRangeProbe1.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.HumidityOutOfRangeProbe2.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.TempInRangeProbe1.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.TempInRangeProbe2.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.TempOutOfRangeProbe1.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.TempOutOfRangeProbe2.getObjectId());
        this.supportedOids.add(EnvironmentalEvents.IntegratedEnvCommunicationEstablished.getObjectId());
        this.oidToFlexEventMapping.put(EnvironmentalEvents.ContactFault1.getObjectId(), "ContactFault1FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.ContactFault2.getObjectId(), "ContactFault2FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.ContactFault3.getObjectId(), "ContactFault3FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.ContactFault4.getObjectId(), "ContactFault4FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.ContactNormal1.getObjectId(), "ContactNormal1FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.ContactNormal2.getObjectId(), "ContactNormal2FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.ContactNormal3.getObjectId(), "ContactNormal3FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.ContactNormal4.getObjectId(), "ContactNormal4FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.EnvironmentCommunicationEstablished.getObjectId(), "EnvironmentCommunicationEstablishedFlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.EnvironmentCommunicationLost.getObjectId(), "EnvironmentCommunicationLostFlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.EnvironmentNoCommunicationSinceLastReboot.getObjectId(), "EnvironmentNoCommunicationSinceLastRebootFlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.HumidityInRangeProbe1.getObjectId(), "HumidityInRangeProbe1FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.HumidityInRangeProbe2.getObjectId(), "HumidityInRangeProbe2FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.HumidityOutOfRangeProbe1.getObjectId(), "HumidityOutOfRangeProbe1FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.HumidityOutOfRangeProbe2.getObjectId(), "HumidityOutOfRangeProbe2FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.TempInRangeProbe1.getObjectId(), "TempInRangeProbe1FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.TempInRangeProbe2.getObjectId(), "TempInRangeProbe2FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.TempOutOfRangeProbe1.getObjectId(), "TempOutOfRangeProbe1FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.TempOutOfRangeProbe2.getObjectId(), "TempOutOfRangeProbe2FlexEvent");
        this.oidToFlexEventMapping.put(EnvironmentalEvents.IntegratedEnvCommunicationEstablished.getObjectId(), "EnvironmentCommunicationEstablishedFlexEvent");
        this.infoEvents = Set.of(EnvironmentalEvents.ContactNormal1.getObjectId(), EnvironmentalEvents.ContactNormal2.getObjectId(), EnvironmentalEvents.ContactNormal3.getObjectId(), EnvironmentalEvents.ContactNormal4.getObjectId(), EnvironmentalEvents.EnvironmentCommunicationEstablished.getObjectId(), EnvironmentalEvents.HumidityInRangeProbe1.getObjectId(), EnvironmentalEvents.HumidityInRangeProbe2.getObjectId(), EnvironmentalEvents.TempInRangeProbe1.getObjectId(), EnvironmentalEvents.TempInRangeProbe2.getObjectId(), EnvironmentalEvents.IntegratedEnvCommunicationEstablished.getObjectId());
    }

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        return this.supportedOids.iterator();
    }

    @Override
    public void update(Event event, int n) {
        logger.info("Passing on Environment event: " + String.valueOf(event.getObjectId()));
        boolean bl = this.infoEvents.contains(event.getObjectId());
        Optional<EnvironmentalEvents> optional = EnvironmentalEvents.findByObjectId(event.getObjectId());
        String string = optional.isPresent() ? optional.get().getEventId() : "100";
        this.theManager.dispatchEvent(new DetailedEvent(event.getObjectId(), event.isActive(), new VarArgFormatter(this.oidToFlexEventMapping.get(event.getObjectId()), PSAggregatorUtils.getAddress(n, this.theManager)), bl, string));
    }
}

