/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.LoadCapability;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinLoadCapInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(MinLoadCapInputEventRule.class);

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(LoadCapability.MinLoadCapabilityLost.getObjectId());
        vector.add(LoadCapability.MinLoadCapabilityRegained.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        if (event.isActive()) {
            if (event.getObjectId().equals((Object)LoadCapability.MinLoadCapabilityRegained.getObjectId())) {
                logger.info("MinimumLoadCapabilityRegained: got an update from PS " + n);
                this.theState.setMinLoadCapabilityLost(n, false);
            } else {
                logger.info("MinimumLoadCapabilityLost: got an update from PS " + n);
                this.theState.setMinLoadCapabilityLost(n, true);
            }
        }
    }
}

