/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.PSAggregatorUtils;
import com.apcc.m11.components.psaggregator.SinglePowerFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletOffInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(OutletOffInputEventRule.class);
    private static final String kSingleOutletOffMsg = "SingleOutletOffFlexEvent";
    private static final ObjectId kSingleOutletOffOid = MultipleEvent.SingleOutletOff.getObjectId();
    private static final ObjectId kSingleOutletRestoredOid = MultipleEvent.SingleOutletRestored.getObjectId();

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(UtilityLineStatus.OutletOff.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        if (event.isActive()) {
            logger.trace("OutletOffInputEventRule: got an update from PS " + n);
            if (!this.theState.getOutletOff()[n]) {
                this.theManager.dispatchEvent(new Event(kSingleOutletRestoredOid, false));
                this.theManager.dispatchEvent(new DetailedEvent(kSingleOutletOffOid, true, new SinglePowerFormatter(kSingleOutletOffMsg, PSAggregatorUtils.getAddress(n, this.theManager)), false, MultipleEvent.SingleOutletOff.getEventId()));
                this.theState.setOutletOff(n, true);
                this.theState.setOutletTurnOffInitiated(n, false);
                this.theState.checkOffInitiatedbyPCNS();
            }
        }
    }
}

