/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.components.psaggregator.PSAggregatorUtils;
import com.apcc.m11.components.psaggregator.SinglePowerFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletOnInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(OutletOnInputEventRule.class);
    private static final String kSingleOutletRestoredMsg = "SingleOutletRestoredFlexEvent";
    private static final ObjectId kSingleOutletOffOid = MultipleEvent.SingleOutletOff.getObjectId();
    private static final ObjectId kSingleOutletRestoredOid = MultipleEvent.SingleOutletRestored.getObjectId();

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(UtilityLineStatus.OutletOn.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        if (event.isActive()) {
            logger.trace("OutletOffInputEventRule: got an update from PS " + n);
            if (this.theState.getOutletOff()[n]) {
                this.theManager.dispatchEvent(new Event(kSingleOutletOffOid, false));
                this.theManager.dispatchEvent(new DetailedEvent(kSingleOutletRestoredOid, true, new SinglePowerFormatter(kSingleOutletRestoredMsg, PSAggregatorUtils.getAddress(n, this.theManager)), true, MultipleEvent.SingleOutletRestored.getEventId()));
                this.theState.setOutletOff(n, false);
            }
        }
    }
}

