/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletTurnOffInitiatedFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kOutletTurnOffInitiatedMsg = "OutletTurnOffInitiatedFlexEvent";
    private static final ObjectId kOutletTurnOffInitiatedOid = ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId();
    private static final Logger logger = LogManager.getLogger(OutletTurnOffInitiatedFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getOutletTurnOffInitiated();
        if (AggregatorState.find_matches(blArray, true) > 1 && this.theState.getLastReportedOutletTurnOffState() == 0) {
            logger.info("firing OutletTurnOffInitiated event ");
            this.theManager.dispatchEvent(new Event(kOutletTurnOffInitiatedOid, true, (IFormatter)new EventMessageFormatter(kOutletTurnOffInitiatedMsg)));
            this.theState.setLastReportedOutletTurnOffState(1);
        }
        if (AggregatorState.find_matches(blArray, true) <= 1 && this.theState.getLastReportedOutletTurnOffState() == 1) {
            logger.info("Clear OutletTurnOffInitiated state");
            this.theManager.dispatchEvent(new Event(kOutletTurnOffInitiatedOid, false));
            this.theState.setLastReportedOutletTurnOffState(0);
        }
    }
}

