/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AggregatorState;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerRestoredFiringLogicRule
extends PSAggregatorRule
implements IRule {
    private static final String kOnlineMsg = "PowerRestoredFlexEvent";
    private static final Logger logger = LogManager.getLogger(PowerRestoredFiringLogicRule.class);

    @Override
    public void calculate() {
        boolean[] blArray = this.theState.getLowBattery();
        boolean[] blArray2 = this.theState.getOnBattery();
        boolean[] blArray3 = this.theState.getPowerOff();
        if (AggregatorState.find_matches(blArray, true) <= 1 && this.theState.getLastReportedLowBatteryState() == 1) {
            logger.info("Return form LowBattery, clear LowBattery state");
            this.theState.setLastReportedLowBatteryState(0);
        }
        if (AggregatorState.find_matches(blArray2, true) <= 1 && this.theState.getLastReportedBatteryState() == 2) {
            logger.info("Return form OnBattery, firing PowerRestored event ");
            this.theManager.dispatchEvent(new Event(UtilityLineStatus.PowerFailed.getObjectId(), false));
            this.theManager.dispatchEvent(new DetailedEvent(UtilityLineStatus.PowerRestored.getObjectId(), true, new EventMessageFormatter(kOnlineMsg), true, UtilityLineStatus.PowerRestored.getEventId()));
            this.theState.setLastReportedBatteryState(1);
            this.theState.setLastReportedPowerOffState(1);
        }
        if (AggregatorState.find_matches(blArray3, true) <= 1 && this.theState.getLastReportedPowerOffState() == 2) {
            logger.info("Return form PowerOff, firing PowerRestored event ");
            this.theManager.dispatchEvent(new Event(ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId(), false));
            this.theState.setLastReportedPowerOffState(1);
        }
    }
}

