/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.psaggregator.rules.redundant;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.psaggregator.EventMessageFormatter;
import com.apcc.m11.components.psaggregator.IEventRule;
import com.apcc.m11.components.psaggregator.PSAggregatorRule;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerRestoredInputEventRule
extends PSAggregatorRule
implements IEventRule {
    private static final String kPowerOnEventMsg = "PowerOnFlexEvent";
    private static final Logger logger = LogManager.getLogger(PowerRestoredInputEventRule.class);

    @Override
    public Iterator<ObjectId> getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.add(UtilityLineStatus.PowerRestored.getObjectId());
        return vector.iterator();
    }

    @Override
    public void update(Event event, int n) {
        if (event.isActive()) {
            logger.info("PowerRestoredInputEventRule: got an update from PS " + n);
            this.theState.setOnBattery(n, false);
            this.theState.setLowBattery(n, false);
            boolean[] blArray = this.theState.getPowerOff();
            if (blArray[n]) {
                this.theState.setPowerOff(n, false);
                this.theManager.dispatchEvent(new DetailedEvent(UtilityLineStatus.PowerRestored.getObjectId(), true, new EventMessageFormatter(kPowerOnEventMsg), true, UtilityLineStatus.PowerRestored.getEventId()));
            }
        }
    }
}

